-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Jun 15, 2025 at 11:12 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `techdb`
--

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `description`, `created_at`, `updated_at`) VALUES
(1, 'Laptops', 'High-performance laptops for gaming, business, and everyday use.', '2024-11-22 23:38:40', '2024-11-22 23:38:40'),
(2, 'Desktops/PC', 'Powerful desktop computers for gaming and professional tasks.', '2024-11-22 23:38:40', '2024-11-23 01:18:11'),
(3, 'Smartphones', 'Latest smartphones with cutting-edge technology.', '2024-11-22 23:38:40', '2024-11-22 23:38:40'),
(4, 'Tablets', 'Portable tablets for work and entertainment.', '2024-11-22 23:38:40', '2024-11-22 23:38:40'),
(5, 'Accessories', 'Various accessories including cases, chargers, and peripherals.', '2024-11-22 23:38:40', '2024-11-22 23:38:40'),
(6, 'Wearables', 'Smartwatches and fitness trackers to keep you connected.', '2024-11-22 23:38:40', '2024-11-22 23:38:40'),
(7, 'Networking', 'Routers, switches, and networking equipment for home and office.', '2024-11-22 23:38:40', '2024-11-22 23:38:40'),
(8, 'Gaming', 'Gaming consoles, games, and accessories for gamers.', '2024-11-22 23:38:40', '2024-11-22 23:38:40'),
(9, 'Home Appliances', 'Smart home devices and appliances for modern living.', '2024-11-22 23:38:40', '2024-11-22 23:38:40'),
(10, 'Software', 'Essential software solutions for productivity and creativity.', '2024-11-22 23:38:40', '2024-11-22 23:38:40');

-- --------------------------------------------------------

--
-- Table structure for table `coupons`
--

CREATE TABLE `coupons` (
  `id` int(11) NOT NULL,
  `code` varchar(20) DEFAULT NULL,
  `discount_percentage` int(11) DEFAULT NULL CHECK (`discount_percentage` between 0 and 100),
  `expiration_date` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `coupons`
--

INSERT INTO `coupons` (`id`, `code`, `discount_percentage`, `expiration_date`) VALUES
(1, 'TECHPLUS', 10, '2024-11-07'),
(2, 'BLACKFRD', 12, '2024-11-30'),
(3, 'BAJRAMIZBRITJE', 20, '2025-06-30');

-- --------------------------------------------------------

--
-- Table structure for table `customer_metrics`
--

CREATE TABLE `customer_metrics` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `total_score` decimal(5,2) NOT NULL,
  `recency` int(11) NOT NULL,
  `frequency` int(11) NOT NULL,
  `monetary` decimal(10,2) NOT NULL,
  `is_high_value` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customer_metrics`
--

INSERT INTO `customer_metrics` (`id`, `user_id`, `total_score`, `recency`, `frequency`, `monetary`, `is_high_value`) VALUES
(2, 4, 72.00, 10, 5, 1200.00, 0);

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `shipping_address` text DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `order_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('Processing','Shipped','Delivered','Canceled') DEFAULT 'Processing',
  `coupon_id` int(11) DEFAULT NULL,
  `original_amount` decimal(10,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `orders`
--

INSERT INTO `orders` (`id`, `user_id`, `total_amount`, `shipping_address`, `payment_method`, `order_date`, `status`, `coupon_id`, `original_amount`) VALUES
(17, 4, 450.00, 'prishtine', 'Credit Card', '2024-11-22 23:05:10', 'Delivered', NULL, NULL),
(18, 4, 2464.00, 'Prizren', 'Credit Card', '2024-11-22 23:11:07', 'Delivered', 2, 2800.00),
(19, 4, 52.80, 'Ferizaj', 'Bank Transfer', '2024-11-22 23:11:45', 'Processing', 2, 60.00),
(20, 4, 1284.80, 'Prishtine', 'Credit Card', '2024-11-23 01:42:07', 'Shipped', 2, 1460.00),
(21, 4, 1400.00, 'ferizaj', 'Cash', '2024-11-23 02:26:08', 'Processing', NULL, 1400.00),
(22, 4, 1400.00, 'Shkup', 'PayPal', '2024-11-23 02:27:55', 'Processing', NULL, 1400.00),
(44, 4, 450.00, 'prishtine', 'Cash', '2024-11-23 19:23:56', 'Delivered', NULL, 450.00),
(45, 4, 1400.00, 'Prishtine', 'Cash', '2024-11-23 23:04:21', 'Processing', NULL, 1400.00),
(46, 4, 792.00, 'Ferizaj', 'Cash', '2024-11-23 23:06:13', 'Processing', 2, 900.00),
(47, 4, 1232.00, 'Prizren', 'Cash', '2024-11-23 23:24:55', 'Processing', 2, 1400.00),
(48, 4, 1400.00, 'Prizren', 'Cash', '2024-11-23 23:30:32', 'Processing', NULL, 1400.00),
(49, 4, 60.00, 'Prizren', 'Cash', '2024-11-23 23:34:41', 'Delivered', NULL, 60.00),
(50, 4, 510.00, 'Prishtine', 'Cash', '2024-11-24 00:02:21', 'Delivered', NULL, 510.00),
(51, 4, 120.00, 'Ferizaj', 'Cash', '2024-11-24 00:04:14', 'Delivered', NULL, 120.00),
(52, 4, 450.00, 'Ferizaj', 'Cash', '2024-11-24 00:05:36', 'Delivered', NULL, 450.00),
(53, 4, 99.99, 'Ferizaj', 'Cash', '2024-11-24 00:24:18', 'Shipped', NULL, 99.99),
(59, 4, 450.00, 'Ferizaj', 'Bank Transfer', '2024-11-24 10:52:55', 'Shipped', NULL, 450.00),
(65, 4, 500.00, NULL, NULL, '2024-11-17 23:00:00', 'Delivered', NULL, NULL),
(66, 4, 150.00, NULL, NULL, '2024-11-18 23:00:00', 'Delivered', NULL, NULL),
(67, 4, 300.00, NULL, NULL, '2024-11-19 23:00:00', 'Delivered', NULL, NULL),
(68, 4, 450.00, NULL, NULL, '2024-11-20 23:00:00', 'Delivered', NULL, NULL),
(69, 4, 600.00, NULL, NULL, '2024-11-21 23:00:00', 'Delivered', NULL, NULL),
(70, 4, 200.00, NULL, NULL, '2024-11-22 23:00:00', 'Delivered', NULL, NULL),
(71, 4, 350.00, NULL, NULL, '2024-11-23 23:00:00', 'Delivered', NULL, NULL),
(72, 9, 670.00, 'Ferizaj,Deshmored e Kombit', 'Cash', '2025-06-13 20:42:04', 'Delivered', NULL, 670.00),
(73, 10, 1120.00, 'ferizaj', 'Cash', '2025-06-13 21:00:18', 'Processing', 3, 1400.00),
(74, 13, 1656.00, 'Hasan Berisha', 'PayPal', '2025-06-15 20:29:00', 'Processing', 3, 2070.00),
(75, 14, 1388.00, 'Ferizaj,Hasan Berisha', 'Cash', '2025-06-15 20:31:06', 'Processing', NULL, 1388.00);

-- --------------------------------------------------------

--
-- Table structure for table `order_items`
--

CREATE TABLE `order_items` (
  `id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `price_at_time` decimal(10,2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `order_items`
--

INSERT INTO `order_items` (`id`, `order_id`, `product_id`, `quantity`, `price_at_time`) VALUES
(14, 17, 2, 1, NULL),
(15, 18, 1, 2, 1400.00),
(16, 19, 3, 1, 60.00),
(17, 20, 1, 1, 1400.00),
(18, 20, 3, 1, 60.00),
(19, 21, 1, 1, 1400.00),
(20, 22, 1, 1, 1400.00),
(21, 44, 2, 1, 450.00),
(22, 45, 1, 1, 1400.00),
(23, 46, 2, 2, 450.00),
(24, 47, 1, 1, 1400.00),
(25, 48, 1, 1, 1400.00),
(26, 49, 3, 1, 60.00),
(27, 50, 2, 1, 450.00),
(28, 50, 3, 1, 60.00),
(29, 51, 3, 2, 60.00),
(30, 52, 2, 1, 450.00),
(31, 53, 3, 1, 60.00),
(32, 53, 5, 1, 39.99),
(39, 59, 2, 1, 450.00),
(49, 72, 7, 1, 670.00),
(50, 73, 1, 1, 1400.00),
(51, 74, 4, 1, 650.00),
(52, 74, 8, 1, 320.00),
(53, 74, 15, 2, 390.00),
(54, 74, 17, 1, 320.00),
(55, 75, 10, 1, 998.00),
(56, 75, 15, 1, 390.00);

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `stock` int(10) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `name`, `price`, `image`, `description`, `category_id`, `stock`) VALUES
(1, 'LENOVO GAMING PC', 1400.00, 'img/1.3.png', 'Lenovo 2023 IdeaCentre Gaming 5 Desktop', 2, 0),
(2, 'LAPTOP HP', 450.00, 'img/2.png', 'HP Elitebook 650 G10 15.6 FHD Business Laptop Computer', 1, 2),
(3, 'GAMING HEADSET', 60.00, 'img/3.png', 'EKSA E900 Pro USB Gaming Headset for PC', 8, 4),
(4, 'IPHONE 14 PRO MAX', 650.00, 'img/4.png', 'The iPhone 14 Pro Max with 128GB storage', 3, 3),
(5, 'MOUSE GAMING', 39.99, 'img/5.png', 'ASUS ROG Spatha X Wireless Gaming Mouse', 8, 2),
(7, 'Benq', 670.00, 'img/6.png', 'Benq PC, programming ', 2, 1),
(8, 'Smartwatch', 320.00, 'img/8.png', 'Smartwatch, gold, new and trendy', 5, 2),
(9, 'Headphones', 230.00, 'img/7.png', 'Headphones, white, bluetooth', 6, 5),
(10, 'MSI Laptop', 998.00, 'img/9.png', 'MSI laptop, gaming, black', 1, 5),
(11, 'SOOMFON Camera', 340.00, 'img/10.png', 'Camera, HD, best quality', 5, 34),
(13, 'Apple Tablet', 340.00, 'img/12.png', 'Apple, Tablet, Black', 4, 12),
(14, 'Playstation 5', 390.00, 'img/13.png', 'Playstation, gaming', 8, 3),
(15, 'Apple Ipods', 390.00, 'img/14.png', 'Apple, Ipods, white, best sound', 5, 7),
(16, 'AR/VR Glasses', 980.00, 'img/15.png', 'AR/VR virtuality, smartglasses', 6, 20),
(17, 'Gaming Desk', 320.00, 'img/17.png', 'Gaming desk, gaming', 9, 22),
(18, 'Nintendo Switch', 600.00, 'img/nintendo.jpg', 'Nintendo Switch™ Mario Kart™ 8 Deluxe Bundle (Full Game Download + 3 Mo. Nintendo Switch Online Membership Included)', 8, 14),
(19, 'Samsung Galaxy S24 Ultra ', 747.00, 'img/samm.jpg', 'Galaxy S24 Ultra Cell Phone, 256GB AI Smartphone, Unlocked Android, 200MP, 100x Zoom Cameras, Fast Processor, Long Battery Life, Edge-to-Edge Display, S Pen, US Version, 2024, Black', 3, 24),
(20, 'Dell Optiplex 5060 Desktop Computer', 280.00, 'img/com.jpg', 'Dell Optiplex 5060 Desktop Computer | Hexa Core Intel i7 (3.2) | 32GB DDR4 RAM | 1TB SSD Solid State | Windows 11 Professional | Home or Office PC (Renewed), Black', 2, 20),
(21, 'Xbox Series', 704.00, 'img/xbox.jpeg', 'Xbox Series X 1TB SSD Console - Includes Xbox Wireless Controller - Up to 120 frames per second - 16 GB RAM - 1 TB SSD Storage - Experience True 4K Gaming - Xbox Velocity Architecture', 8, 18),
(22, 'Rii Keyboard and Mouse Set', 28.00, 'img/keym.jpg', 'Rii Keyboard and Mouse Set, Rainbow LED Backlit Multimedia PC Keyboard, Colorful Breathing Backlit Gaming Mouse for Work or Play', 5, 28),
(23, 'Motorola MG7550', 280.00, 'img/mod.jpg', 'Motorola MG7550 - Modem with Built in WiFi | Approved for Comcast Xfinity, Cox | For Plans Up to 300 Mbps | DOCSIS 3.0 + AC1900 WiFi Router | Power Boost Enabled', 7, 10),
(24, 'Tenda AC1200 Smart WiFi Router', 180.00, 'img/rout.jpg', 'Tenda AC1200 Smart WiFi Router, High Speed Dual Band Wireless Internet Router with Smart APP, 4 x 100 Mbps Fast Ethernet Ports, Supports Guest WiFi, Access Point Mode, IPv6 and Parental Controls(AC6)', 7, 10);

-- --------------------------------------------------------

--
-- Table structure for table `reviews`
--

CREATE TABLE `reviews` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `rating` int(11) DEFAULT NULL CHECK (`rating` between 1 and 5),
  `comment` varchar(255) NOT NULL,
  `review_date` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `reviews`
--

INSERT INTO `reviews` (`id`, `user_id`, `product_id`, `rating`, `comment`, `review_date`) VALUES
(1, 4, 1, 5, '', '2024-11-06 00:33:36'),
(2, 4, 2, 5, '', '2024-11-10 22:13:44'),
(3, 4, 1, 4, '', '2024-11-24 12:51:10'),
(4, 4, 1, 5, '', '2024-11-24 12:51:17'),
(5, 4, 1, 2, '', '2024-11-24 12:51:19'),
(6, 4, 1, 2, '', '2024-11-24 12:52:20'),
(7, 4, 7, 4, '', '2024-11-24 12:58:24');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('user','admin') DEFAULT 'user',
  `loyalty_points` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `customer_badge` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `role`, `loyalty_points`, `created_at`, `customer_badge`) VALUES
(4, 'not avilable', 'test1@gmail.com', '1234', 'user', 180, '2024-11-10 22:40:46', 'Bronze Member'),
(5, 'admin', 'admin@example.com', '1234', 'admin', 0, '2024-11-10 22:40:46', NULL),
(9, 'jusra', 'jusramurati22@gmail.com', '$2y$10$7/YIEV0jhblM2RMfmHFxWuRAWJuGjpasER0iX6H76ObSHzc92njum', 'user', 0, '2025-06-13 20:38:46', 'Bronze Member'),
(10, 'dulla', 'dulla2@gmail.com', '$2y$10$I8XQ4v2MNAJaWxpVX7tsc.k70C/.3xvYaswsYzYo5KKbxlXJlZC7O', 'user', 112, '2025-06-13 20:58:52', 'Bronze Member'),
(11, 'esra', 'esra12@gmail.com', 'esra1234!', 'user', 0, '2025-06-13 21:02:57', NULL),
(12, 'Aldi Stublla', 'aldistublla1@gmail.com', 'aldi1234.', 'user', 0, '2025-06-15 20:25:58', NULL),
(13, 'Murat Murati', 'murat12@gmail.com', 'murat.102018', 'user', 165, '2025-06-15 20:26:43', 'Bronze Member'),
(14, 'Selvete Murati', 'selvete12@gmail.com', 'selvete.102018', 'user', 138, '2025-06-15 20:30:03', 'Bronze Member'),
(15, 'Jusuf Murati', 'jusuf12@gmail.com', 'jusuf.102018', 'user', 0, '2025-06-15 21:00:51', NULL),
(16, 'Shkodran', 'shkodranqorrolli@gmail.com', '$2y$10$H5R3zBXj4n1nPssv6P2EIObC7MI9/tSgOGWhby3c81g/0Q4ZNwr86', 'user', 0, '2025-06-15 21:02:58', NULL),
(17, 'Edonis Bislim', 'edonisi1@gmail.com', 'edonis.2005', 'user', 0, '2025-06-15 21:05:15', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `user_recommendations`
--

CREATE TABLE `user_recommendations` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `score` decimal(5,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_recommendations`
--

INSERT INTO `user_recommendations` (`id`, `user_id`, `product_id`, `score`) VALUES
(3, 4, 1, 88.00);

-- --------------------------------------------------------

--
-- Table structure for table `wishlist`
--

CREATE TABLE `wishlist` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `product_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `wishlist`
--

INSERT INTO `wishlist` (`id`, `user_id`, `product_id`) VALUES
(44, 4, 2),
(46, 4, 3),
(53, 9, 4);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `coupons`
--
ALTER TABLE `coupons`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `customer_metrics`
--
ALTER TABLE `customer_metrics`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `fk_orders_coupon` (`coupon_id`);

--
-- Indexes for table `order_items`
--
ALTER TABLE `order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_category_id` (`category_id`);

--
-- Indexes for table `reviews`
--
ALTER TABLE `reviews`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- Indexes for table `user_recommendations`
--
ALTER TABLE `user_recommendations`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `wishlist`
--
ALTER TABLE `wishlist`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `wishlist_ibfk_1` (`user_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `coupons`
--
ALTER TABLE `coupons`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `customer_metrics`
--
ALTER TABLE `customer_metrics`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=76;

--
-- AUTO_INCREMENT for table `order_items`
--
ALTER TABLE `order_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=57;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT for table `reviews`
--
ALTER TABLE `reviews`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- AUTO_INCREMENT for table `user_recommendations`
--
ALTER TABLE `user_recommendations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `wishlist`
--
ALTER TABLE `wishlist`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=54;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `customer_metrics`
--
ALTER TABLE `customer_metrics`
  ADD CONSTRAINT `customer_metrics_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `fk_orders_coupon` FOREIGN KEY (`coupon_id`) REFERENCES `coupons` (`id`),
  ADD CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`coupon_id`) REFERENCES `coupons` (`id`);

--
-- Constraints for table `order_items`
--
ALTER TABLE `order_items`
  ADD CONSTRAINT `order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `products`
--
ALTER TABLE `products`
  ADD CONSTRAINT `fk_products_categories` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `reviews`
--
ALTER TABLE `reviews`
  ADD CONSTRAINT `reviews_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `reviews_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`);

--
-- Constraints for table `user_recommendations`
--
ALTER TABLE `user_recommendations`
  ADD CONSTRAINT `user_recommendations_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_recommendations_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `wishlist`
--
ALTER TABLE `wishlist`
  ADD CONSTRAINT `wishlist_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `wishlist_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
