

Admin login: Username"admin" , Password"1234"







# TechAI: Revolutionizing Retail and E-Commerce with AI

## Table of Contents
1. [Overview](#overview)
2. [Key Features](#key-features)
3. [Technologies Used](#technologies-used)
4. [Installation and Setup](#installation-and-setup)
5. [How It Works](#how-it-works)
6. [Admin Panel Features](#admin-panel-features)
7. [Loyalty Points and Rewards System](#loyalty-points-and-rewards-system)

8. [Acknowledgments](#acknowledgments)

---

## Overview

**TechAI** is an innovative solution designed to transform the retail and e-commerce landscape using the power of AI. Developed as part of the **Champion Trials-48 Hour Challenge**, this project leverages machine learning and AI-driven tools to enhance the customer experience, streamline shopping, and boost operational efficiency.

The system combines AI-powered recommendations, a chatbot for customer interaction, a loyalty and rewards system, and advanced admin features to provide a seamless shopping experience.

---

## Key Features

1. **AI-Driven Product Recommendations**:
   - Suggests products based on user behavior and purchase history.

2. **AI Chatbot**:
   - Provides real-time customer support and product guidance.

3. **Loyalty Points and Badges**:
   - Rewards users with points and badges for purchases and engagement, redeemable for discounts and coupons.

4. **Secure User Authentication**:
   - Implements a robust login and signup system with data validation and encryption.

5. **Shopping Cart and Checkout**:
   - Dynamic cart updates and secure checkout processes.

6. **Admin Panel**:
   - Comprehensive tools for managing products, users, coupons, and orders.
   - Real-time alerts for low stock, sales forecasts, and popular products.

7. **Order Tracking**:
   - Detailed order tracking and status updates for users.

8. **PDF Invoice Generation**:
   - Automatically generates and provides downloadable invoices for orders.

9. **Coupons Management**:
   - Create, edit, and manage discount coupons that users can apply at checkout.

---

## Technologies Used

1. **Backend**: PHP
2. **Database**: MySQL
3. **Frontend**: HTML, CSS, JavaScript
4. **AI Integration**:
   - Recommendation Engine
   - Chatbot Framework
5. **Tools**:
   - Libraries for PDF generation
   - Database connection and handling

---

## Installation and Setup

1. Clone the repository:
   ```bash
   git clone https://github.com/your-repo-url.git
   ```
2. Import the database:
   - Use the provided `techdb.sql` file to set up the database in your MySQL server.
3. Configure the project:
   - Update database credentials in `config.php`.
4. Launch the application:
   - Start the local server (e.g., XAMPP or WAMP) and navigate to the project directory.
5. Access the application:
   - Open your browser and go to `http://localhost/techai-AbdullahMurati`.
6. User login: test, 1234
7. Admin login: admin, 1234

---

## How It Works

- **User Side**:
  - Users can register, log in, browse products, and add items to their cart or wishlist.
  - They can redeem loyalty points, use coupons, and earn badges for purchases.
  - The AI chatbot offers real-time assistance for queries and personalized shopping recommendations.

- **Admin Side**:
  - Administrators use the dashboard to manage users, products, orders, and coupons.
  - Advanced features include stock alerts, sales forecasting, and analytics on popular products.

---

## Admin Panel Features

1. **Alerts for Low Stock**:
   - Real-time notifications when product inventory drops below a threshold.

2. **Sales Forecasting**:
   - Predict future sales based on historical data to help plan inventory and campaigns.

3. **Popular Products Analytics**:
   - Displays insights on top-selling products for better marketing strategies.

4. **User Management**:
   - Add, update, or delete user accounts and view user activity.

5. **Product Management**:
   - Manage product listings, including prices, descriptions, and stock levels.

6. **Coupons Management**:
   - Create, edit, and delete discount coupons.

7. **Order Management**:
   - View, update, or cancel customer orders with detailed tracking.

---

## Loyalty Points and Rewards System

**TechAI** includes an engaging rewards system to incentivize customer loyalty:

1. **Loyalty Points**:
   - Customers earn points for every purchase, calculated based on the order total.
   - Points can be redeemed for discounts during checkout.

2. **Badges**:
   - Users are awarded badges for milestones like frequent purchases or high-value orders.
   - Badges offer exclusive discounts and perks.

3. **Coupon Integration**:
   - Loyalty points can be combined with admin-created coupons for additional discounts.
   - Users apply these directly during checkout.

4. **Admin Control**:
   - Administrators can set rules for earning points, thresholds for badges, and manage active rewards.

---


---
## AI features in TechAI:

1. AI-Driven Product Recommendations:

Suggests products based on user preferences using collaborative filtering, content-based filtering, or hybrid techniques.
Personalizes the shopping experience and boosts sales.
2. AI Chatbot:

Provides real-time customer support and product guidance using NLP.
Enhances user engagement and reduces the need for human support.
3. Sales Forecasting:

Predicts future demand using historical sales data and time-series algorithms.
Optimizes inventory and marketing strategies.
4. Popular Product Analytics:

Identifies top-selling products by analyzing user interactions and purchases.
Helps focus on high-performing products for marketing.
5. Customer Behavior Analysis:

Tracks and clusters user actions to personalize recommendations.
Enhances customer retention and satisfaction.
## Acknowledgments

This project was created as part of the **Champion Trials-48 Hour Challenge(hackathon)  and Code Fest 2025**. Special thanks to the organizers, mentors, for their support and guidance.

---


